#include "FreeCamera.h"

FreeCamera::FreeCamera(Vector3 origin, Vector3 pitchYawRoll, Vector3 minimum, Vector3 maximum) : Camera(1.0f, origin, pitchYawRoll)
{
	//Set values passed in, pass some to base constructor
	_MouseRotationSpeed = _Speed * 5.0f;
	_MinimumBounds = minimum;
	_MaximumBounds = maximum;
	Reset();
}

FreeCamera::FreeCamera(float speed, Vector3 origin, Vector3 pitchYawRoll, Vector3 minimum, Vector3 maximum) : Camera(speed, origin, pitchYawRoll)
{
	//Set values passed in, pass some to base constructor
	_MouseRotationSpeed = _Speed * 5.0f;
	_MinimumBounds = minimum;
	_MaximumBounds = maximum;
	Reset();
}

FreeCamera::~FreeCamera()
{

}

void FreeCamera::Animate(float dt)
{

}

void FreeCamera::MoveForward(float dt)
{
	_PositionVector.x += _ForwardVector.x * _Speed * dt;
	_PositionVector.y += _ForwardVector.y * _Speed * dt;
	_PositionVector.z += _ForwardVector.z * _Speed * dt;
	Update();
}

void FreeCamera::MoveRight(float dt)
{
	_PositionVector.x += _RightVector.x * _Speed * dt;
	_PositionVector.y += _RightVector.y * _Speed * dt;
	_PositionVector.z += _RightVector.z * _Speed * dt;
	Update();
}

void FreeCamera::MoveUp(float dt)
{
	_PositionVector.y += _Speed * dt;
	Update();
}

void FreeCamera::RotateX(float dt)
{
	_Pitch += _MouseRotationSpeed * dt;
	Update();
}

void FreeCamera::RotateY(float dt)
{
	_Yaw += _MouseRotationSpeed * dt;
	Update();
}

void FreeCamera::RotateZ(float dt)
{
	_Roll += _MouseRotationSpeed * dt;
	Update();
}

void FreeCamera::RotateFromMouse(float xOffset, float yOffset, float dt)
{
	if (xOffset > 0)
	{
		_Yaw += _MouseRotationSpeed * dt * log(abs(xOffset));
	}

	else if (xOffset < 0)
	{
		_Yaw += _MouseRotationSpeed * dt * log(abs(xOffset)) * -1;
	}

	if (yOffset > 0)
	{
		_Pitch += _MouseRotationSpeed * dt * log(abs(yOffset)) * -1;
	}

	else if (yOffset < 0)
	{
		_Pitch += _MouseRotationSpeed * dt * log(abs(yOffset));
	}

	Update();
}